% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipft.R
\name{ipfEstimate}
\alias{ipfEstimate}
\title{This function estimates the location of the test observations}
\usage{
ipfEstimate(ipfmodel, locdata, loctest = NULL)
}
\arguments{
\item{ipfmodel}{an ipfModel}

\item{locdata}{a matrix or a data frame containing the position of the training set observations}

\item{loctest}{a matrix or a data frame containing the position of the test set observations}
}
\value{
An S4 class object of type ipfEstimation, with the following slots:
                location ->   a matrix with the predicted locations
                grouploc ->   a matrix with the location data for each group
                errors   ->   a numeric vector with the errors
}
\description{
This function estimates the location of the test observations
}
\examples{

    model <- ipfKnn(ipftrain[, 1:168], ipftest[, 1:168])
    estimation <- ipfEstimate(model, ipftrain[, 169:170], ipftest[, 169:170])

    groups <- ipfGroup(ipftrain, LONGITUDE, LATITUDE)
    model <- ipfProb(ipftrain[, 1:168], ipftest[, 1:168], groups, k = 9, delta = 10)
    estimation <- ipfEstimate(model, ipftrain[, 169:170], ipftest[, 169:170])

}
