% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/country_networks.R
\name{country_networks}
\alias{country_networks}
\title{Country-level IP networks}
\source{
\url{https://www.iwik.org/ipcountry/} (updated daily)
}
\usage{
country_networks(country, ..., collapse = TRUE)
}
\arguments{
\item{country}{Character vector of two-letter country codes (ISO 3166-1 alpha-2)}

\item{...}{These dots are for future extensions and must be empty.}

\item{collapse}{If \code{TRUE} (the default), contiguous networks are collapsed.
See \code{\link[=collapse_networks]{collapse_networks()}}.}
}
\value{
A data frame with 2 variables:
\itemize{
\item \code{country}: A character vector
\item \code{network}: A list of \code{\link{ip_network}} vectors
}
}
\description{
Retrieve lists of IP networks registered to specific countries.
}
\details{
This function requires an internet connection to download network lists.
}
\examples{
\dontrun{
country_networks(c("GB", "US"))

country_networks(c("GB", "US"), collapse = FALSE)
}
}
