% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciregic.R
\name{vcov.summary.ciregic}
\alias{vcov.summary.ciregic}
\title{Variance-covariance matrix of \code{summary.ciregic}}
\usage{
\method{vcov}{summary.ciregic}(object, ...)
}
\arguments{
\item{object}{an object of class \code{summary.ciregic}, which is a result of a call to \code{ciregic}}

\item{...}{further arguments}
}
\value{
The estimated bootstrap variance-covariance matrix
}
\description{
\code{vcov} method for class \code{summary.ciregic}
}
\details{
\code{vcov} returns the variance-covariance matrix of the fitted semiparametric regression model.
}
\examples{
## Continuing the ciregic(...) example
\dontshow{
fit <- ciregic(Surv2(v, u, c) ~ z1 + z2, data = simdat,
               alpha = c(1, 1), nboot = 0, do.par = FALSE)
}
vcov(summary(fit))

}
\seealso{
The fitted semiparametric regression on cumulative incidence function with interval-censored competing risks data \code{\link[intccr]{ciregic}}, summary of the fitted semiparametric regression model \code{\link[intccr]{summary.ciregic}}, and values of the predicted cumulative incidence functions \code{\link[intccr]{predict.ciregic}}
}
