% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisher.R
\name{fisher}
\alias{fisher}
\title{Fisher's natural breaks classification}
\usage{
fisher(vec, n = 7, diglab = 2)
}
\arguments{
\item{vec}{a continuous numerical variable}

\item{n}{number of classes required (n = 7 is default)}

\item{diglab}{number of digits (n = 2 is default)}
}
\value{
Vector with clustering
}
\description{
The function provides an interface to finding class intervals for continuous numerical variables, for example for choosing colours for plotting maps.
}
\details{
The "fisher" style uses the algorithm proposed by W. D. Fisher (1958) and discussed by Slocum et al. (2005) as the Fisher-Jenks algorithm.
This function is adopted from the classInt package.
}
\references{
Bivand, R. (2018). classInt: Choose Univariate Class Intervals. R package version 0.2-3. \url{https://CRAN.R-project.org/package=classInt}

Fisher, W. D. 1958 "On grouping for maximum homogeneity", Journal of the American Statistical Association, 53, pp. 789–798.
doi: 10.1080/01621459.1958.10501479.
}
\author{
Martin Haringa
}
