% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_types.R
\name{inspect_types}
\alias{inspect_types}
\title{Summarise and compare column types in one or two dataframes.}
\usage{
inspect_types(df1, df2 = NULL, show_plot = FALSE)
}
\arguments{
\item{df1}{A data frame.}

\item{df2}{An optional second data frame for comparison.}

\item{show_plot}{Logical argument determining whether plot is generated 
in addition to tibble output.  Default is \code{FALSE}.}
}
\value{
A tibble summarising the count and percentage of different 
column types for one or a pair of data frames.
}
\description{
Summarise and compare column types in one or two dataframes.
}
\details{
When \code{df2 = NULL}, a tibble is returned with the columns
\itemize{
  \item \code{type} character vector containing the column types in \code{df1}.
  \item \code{cnt} integer counts of each type.
  \item \code{pcnt} the percentage of all columns with each type.
  \item \code{col_name} the names of columns with each type.
}
When a second data frame \code{df2} is specified, column type summaries 
are tabulated for both data frames to enable comparison of contents. 
The resulting tibble has the columns
\itemize{
  \item \code{type} character vector containing the column types in 
  \code{df1} and \code{df2}.
  \item \code{cnt_1}, \code{cnt_2} pair of integer columns containing counts of each type - 
  in each of \code{df1} and \code{df2}.
  \item \code{pcnt_1}, \code{pcnt_2} pair of columns containing the percentage of 
  columns with each type - the data frame name are appended.
}
}
\examples{
data("starwars", package = "dplyr")
# get tibble of column types for the starwars data
inspect_types(starwars)
# get column types and show as barplot
inspect_types(starwars, show_plot = TRUE)
# compare two data frames
inspect_types(starwars, starwars[, -1], show_plot = TRUE)
}
