% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inpdfr_ANA_freqWordCor.R
\name{getXFreqWord}
\alias{getXFreqWord}
\title{Returns most frequent words}
\usage{
getXFreqWord(wordF, occuWords)
}
\arguments{
\item{wordF}{The data.frame containing word occurrences.}

\item{occuWords}{The minimum number of occurrences for words to be returned.}
}
\value{
A vector with most frequent words.
}
\description{
Returns most frequent words
}
\examples{
data("loremIpsum")
loremIpsum01 <- loremIpsum[1:100]
loremIpsum02 <- loremIpsum[101:200]
loremIpsum03 <- loremIpsum[201:300]
loremIpsum04 <- loremIpsum[301:400]
loremIpsum05 <- loremIpsum[401:500]
subDir <- "RESULTS"
dir.create(file.path(getwd(), subDir), showWarnings = FALSE)
write(x = loremIpsum01, file = "RESULTS/loremIpsum01.txt")
write(x = loremIpsum02, file = "RESULTS/loremIpsum02.txt")
write(x = loremIpsum03, file = "RESULTS/loremIpsum03.txt")
write(x = loremIpsum04, file = "RESULTS/loremIpsum04.txt")
write(x = loremIpsum05, file = "RESULTS/loremIpsum05.txt")
wordOccuDF <- getwordOccuDF(mywd = paste0(getwd(), "/RESULTS"), 
  excludeSW = FALSE)
file.remove(list.files(pattern = "loremIpsum"))
getXFreqWord(wordF = wordOccuDF, occuWords = 5)
}

