% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inpdfr_ANA_ECO_entropart.R
\name{doMetacomEntropart}
\alias{doMetacomEntropart}
\title{Performs an analysis of ecological diversity and structure.}
\usage{
doMetacomEntropart(wordF, getPlot = c(TRUE, TRUE, TRUE, TRUE),
  getTextSink = c(TRUE, TRUE, TRUE, TRUE), mwidth = 800, mheight = 800,
  formatType = "png")
}
\arguments{
\item{wordF}{The data.frame containing word occurrences.}

\item{getPlot}{A vector with four logical values. If \code{getPlot[1]==TRUE},
the \code{MetaCommunity} object is plotted and saved in the RESULTS directory.
If \code{getPlot[2]==TRUE}, the \code{DivPart} analisis is plotted and
saved in the RESULTS directory. If \code{getPlot[3]==TRUE}, the \code{DivEst}
analisis is plotted and saved in the RESULTS directory. If \code{getPlot[4]==TRUE},
the \code{DivProfile} analisis is plotted and saved in the RESULTS directory.}

\item{getTextSink}{A vector with four logical values. If \code{getTextSink[1]==TRUE},
the \code{MetaCommunity} object is saved in the RESULTS directory.
If \code{getTextSink[2]==TRUE}, the \code{DivPart} analisis is saved in the
RESULTS directory. If \code{getTextSink[3]==TRUE}, the \code{DivEst}
analisis is saved in the RESULTS directory. If \code{getTextSink[4]==TRUE},
the \code{DivProfile} analisis is saved in the RESULTS directory.}

\item{mwidth}{The width of the plot in pixels.}

\item{mheight}{The height of the plot in pixels.}

\item{formatType}{The format for the output file ("eps", "pdf", "png", "svg", "tiff", "jpeg", "bmp").}
}
\value{
A \code{MetaCommunity} object (see \code{\link[entropart]{entropart-package}}).
}
\description{
Uses the \code{\link[entropart]{entropart-package}} to analyse the word-occurrence data.frame,
   considering words as species and documents as communities.
}
\examples{
data("loremIpsum")
loremIpsum01 <- loremIpsum[1:100]
loremIpsum02 <- loremIpsum[101:200]
loremIpsum03 <- loremIpsum[201:300]
loremIpsum04 <- loremIpsum[301:400]
loremIpsum05 <- loremIpsum[401:500]
subDir <- "RESULTS"
dir.create(file.path(getwd(), subDir), showWarnings = FALSE)
write(x = loremIpsum01, file = "RESULTS/loremIpsum01.txt")
write(x = loremIpsum02, file = "RESULTS/loremIpsum02.txt")
write(x = loremIpsum03, file = "RESULTS/loremIpsum03.txt")
write(x = loremIpsum04, file = "RESULTS/loremIpsum04.txt")
write(x = loremIpsum05, file = "RESULTS/loremIpsum05.txt")
wordOccuDF <- getwordOccuDF(mywd = paste0(getwd(), "/RESULTS"), 
  excludeSW = FALSE)
file.remove(list.files(pattern = "loremIpsum"))
doMetacomEntropart(wordF = wordOccuDF)
}

