% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/innsight_ggplot2.R
\docType{class}
\name{innsight_ggplot2}
\alias{innsight_ggplot2}
\title{S4 class for ggplot2-based plots}
\description{
The S4 class \code{innsight_ggplot2} visualizes the results of the methods
provided from the package \code{innsight} using \link{ggplot2}. In addition, it
allows easier analysis of the results and modification of the
visualization by basic generic functions. The individual slots are for
internal use only and should not be modified.
}
\details{
This S4 class is a simple extension of a \link{ggplot2} object that enables
a more detailed analysis of the results and a way to visualize the results
of models with multiple input layers (e.g., images and tabular data).
The distinction between one and multiple input layers decides the behavior
of this class, and this information is stored in the slot \code{multiplot}.
\subsection{One input layer (\code{multiplot = FALSE})}{

If the model passed to a method from the innsight package has only one
input layer, the S4 class \code{innsight_ggplot2} is just a wrapper of a
single ggplot2 object. This object is stored as a 1x1 matrix in
the slot \code{grobs} and the slots \code{output_strips} and \code{col_dims} contain
only empty lists because no second line of stripes describing the input
layer is needed.
Although it is an object of the class \code{innsight_ggplot2},
the generic function \link{+.innsight_ggplot2} provides a ggplot2-typical usage
to modify the representation. The graphical objects are simply forwarded to
the ggplot2 object in \code{grobs} and added using \link[ggplot2:gg-add]{ggplot2::+.gg}. In addition,
some generic functions are implemented to visualize or examine
individual aspects of the overall plot in more detail. All available
generic functions are listed below:
\itemize{
\item \code{\link[=+.innsight_ggplot2]{+}}
\item \code{\link[=plot.innsight_ggplot2]{plot}},
\code{\link[=print.innsight_ggplot2]{print}} and
\code{\link[=show.innsight_ggplot2]{show}}
(all behave the same)
\item \code{\link[=[.innsight_ggplot2]{[}}
\item \code{\link[=[[.innsight_ggplot2]{[[}}
}

\emph{Note:} In this case, the generic function \verb{[<-} is not implemented
because there is only one ggplot2 object and not multiple ones.
}

\subsection{Multiple input layers (\code{multiplot = TRUE})}{

If the passed model has multiple input layers, a ggplot2 object is
created for each data point, input layer and output node and then stored
as a matrix in the slot \code{grobs}. During visualization, these are combined
using the function \code{\link[gridExtra:arrangeGrob]{gridExtra::arrangeGrob}} and corresponding strips for
the output layer/node names are added at the top. The labels, column
indices and theme for the extra row of strips are stored in the slots
\code{output_strips} and \code{col_dims}. The strips for the input
layer and the data points (if not boxplot) are created using
\link[ggplot2:facet_grid]{ggplot2::facet_grid} in the individual ggplot2 objects of the grob matrix.
An example structure is shown below:

\if{html}{\out{<div class="sourceCode">}}\preformatted{|      Output 1: Node 1      |      Output 1: Node 3      |
|   Input 1   |   Input 2    |   Input 1   |   Input 2    |
|---------------------------------------------------------|-------------
|             |              |             |              |
| grobs[1,1]  |  grobs[1,2]  | grobs[1,3]  | grobs[1,4]   | data point 1
|             |              |             |              |
|---------------------------------------------------------|-------------
|             |              |             |              |
| grobs[2,1]  |  grobs[2,2]  | grobs[2,3]  | grobs[2,4]   | data point 2
|             |              |             |              |
}\if{html}{\out{</div>}}

Similar to the other case, generic functions are implemented to add
graphical objects from ggplot2, create the whole plot or select only
specific rows/columns. The difference, however, is that each entry in
each row and column is a separate ggplot2 object and can be modified
individually. For example, adds \code{+ ggplot2::xlab("X")} the x-axis label
"X" to all objects and not only to those in the last row. The generic
function \code{\link[=[<-.innsight_ggplot2]{[<-}} allows you to replace
a selection of objects in \code{grobs} and thus, for example, to change
the x-axis title only in the bottom row. All available
generic functions are listed below:
\itemize{
\item \code{\link[=+.innsight_ggplot2]{+}}
\item \code{\link[=plot.innsight_ggplot2]{plot}},
\code{\link[=print.innsight_ggplot2]{print}} and
\code{\link[=show.innsight_ggplot2]{show}}
(all behave the same)
\item \code{\link[=[.innsight_ggplot2]{[}}
\item \code{\link[=[[.innsight_ggplot2]{[[}}
\item \code{\link[=[<-.innsight_ggplot2]{[<-}}
\item \code{\link[=[<-.innsight_ggplot2]{[[<-}}
}

\emph{Note:} Since this is not a standard visualization, the suggested packages
\code{'grid'}, \code{'gridExtra'} and \code{'gtable'} must be installed.
}
}
\section{Slots}{

\describe{
\item{\code{grobs}}{The individual ggplot2 objects arranged as a matrix (see
details for more information)}

\item{\code{multiplot}}{A logical value indicating whether there are multiple
input layers and therefore correspondingly individual ggplot2 objects
instead of one single object.}

\item{\code{output_strips}}{A list containing the labels and themes of the strips
for the output nodes. This slot is only relevant if \code{multiplot} is \code{TRUE}.}

\item{\code{col_dims}}{A list of the length of \code{output_strips} assigning to
each strip the column index of \code{grobs} of the associated strip.}

\item{\code{boxplot}}{A logical value indicating whether the result of individual
data points or a boxplot over multiple instances is displayed.}
}}

