% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BumpRiverStage.R
\name{BumpRiverStage}
\alias{BumpRiverStage}
\title{Adjustment for Implausible River Stage}
\usage{
BumpRiverStage(r, outlets, min.drop = 1e-06)
}
\arguments{
\item{r}{RasterLayer.
Numeric cell values represent river stages.}

\item{outlets}{SpatialPoints*, SpatialLines*, SpatialPolygons* or Extent.
Designates the location of discharge outlets.
The \code{\link{rasterize}} function is used to locate outlet cells in the raster grid \code{r}.}

\item{min.drop}{numeric.
Minimum drop in stage between adjacent river cells.}
}
\value{
Returns a RasterLayer with cell values representing the vertical change in stream stage.
  These changes can be added to \code{r} to ensure that water always flows downhill.
}
\description{
This function decreases stage values in river cells if they are implausible
with respect to water always flowing downhill.
}
\details{
The \href{https://en.wikipedia.org/wiki/Lee_algorithm}{Lee algorithm} (Lee, 1961)
  is used to identify flow paths among the modeled river cells.
  An analysis of river cell stage values along a flow path identifies any problematic cells
  that are obstructing downhill surface-water flow.
  Stage values for these problematic cells are then lowered to an acceptable elevation.
}
\examples{
print("notyet")

}
\references{
Lee, C.Y., 1961, An algorithm for path connections and its applications:
  IRE Transactions on Electronic Computers, v. EC-10, no. 2, p. 346--365.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{utilities}
