% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cities.R
\docType{data}
\name{cities}
\alias{cities}
\title{Cities and Towns}
\format{
A \href{https://r-spatial.github.io/sf/articles/sf1.html}{simple feature} with fields:
\describe{
\item{\code{name}}{City name.}
\item{\code{id}}{Unique identifier.}
\item{\code{geometry}}{Zero-dimensional geometry containing a single point.}
}
See \code{\link{crs}} dataset for coordinate reference system information.
}
\source{
Spatial point extracts were obtained from the
Master Address File / Topologically Integrated Geographic Encoding and Referencing
(\href{https://www.census.gov/geographies/mapping-files/time-series/geo/tiger-line-file.2022.html#list-tab-ZTNQS959OZX8M0ODED}{MAF/TIGER})
Database (MTDB), 2022 data collection, released September 30, 2022. Which is a part of the
U.S. Department of Commerce, U.S. Census Bureau, Geography Division/Cartographic Products Branch.
The centroids of these extracts were cropped to the study area, and any non-essential data was removed.
}
\usage{
cities
}
\description{
Cities and towns (populated places) in the vicinity of Idaho National Laboratory,
eastern Idaho as of January 1, 2022.
}
\examples{
print(cities)

plot(cities["name"], pch = 19)
}
\keyword{datasets}
