% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_functions.R
\name{make_inlamemi_control.family}
\alias{make_inlamemi_control.family}
\title{Make "control.family" argument for passing to the "inla" function}
\usage{
make_inlamemi_control.family(
  formula_mis = NULL,
  family_moi,
  error_type = "classical",
  prior.prec.moi = NULL,
  prior.prec.berkson = NULL,
  prior.prec.classical = NULL,
  prior.prec.imp = NULL,
  initial.prec.moi = NULL,
  initial.prec.berkson = NULL,
  initial.prec.classical = NULL,
  initial.prec.imp = NULL,
  control.family.moi = NULL,
  control.family.berkson = NULL,
  control.family.classical = NULL,
  control.family.imp = NULL,
  control.family = NULL
)
}
\arguments{
\item{formula_mis}{an object of class "formula", describing the missingness model. Does not need to have a response variable, since this will always be a binary missingness indicator.}

\item{family_moi}{a string indicating the likelihood family for the model of interest (the main model).}

\item{error_type}{type of error (one or more of "classical", "berkson", "missing")}

\item{prior.prec.moi}{a string containing the parameters for the prior for the precision of the residual term for the model of interest.}

\item{prior.prec.berkson}{a string containing the parameters for the prior for the precision of the error term for the Berkson error model.}

\item{prior.prec.classical}{a string containing the parameters for the prior for the precision of the error term for the classical error model.}

\item{prior.prec.imp}{a string containing the parameters for the precision of the latent variable x, which is the variable being described in the imputation model.}

\item{initial.prec.moi}{the initial value for the precision of the residual term for the model of interest.}

\item{initial.prec.berkson}{the initial value for the precision of the residual term for the Berkson error term.}

\item{initial.prec.classical}{the initial value for the precision of the residual term for the classical error term.}

\item{initial.prec.imp}{the initial value for the precision of the residual term for the latent variable r.}

\item{control.family.moi}{control.family component for model of interest. Can be specified here using the inla syntax instead of passing the "prior.prec..." and "initial.prec..." arguments, or in the cases when other hyperparameters are needed for the model of interest, see for instance survival models.}

\item{control.family.berkson}{control.family component Berkson model. Can be specified here using the inla syntax instead of passing the "prior.prec..." and "initial.prec..." arguments. Useful in the cases when more flexibility is needed, for instance if one wants to specify a different prior distribution than Gamma.}

\item{control.family.classical}{control.family component for classical model. Can be specified here using the inla syntax instead of passing the "prior.prec..." and "initial.prec..." arguments. Useful in the cases when more flexibility is needed, for instance if one wants to specify a different prior distribution than Gamma.}

\item{control.family.imp}{control.family component for imputation model. Can be specified here using the inla syntax instead of passing the "prior.prec..." and "initial.prec..." arguments. Useful in the cases when more flexibility is needed, for instance if one wants to specify a different prior distribution than Gamma.}

\item{control.family}{control.family for use in inla (can be provided directly instead of passing the "prior.prec...." and "initial.prec..." arguments. If this is specified, any other "control.family..." or "prior.prec..." arguments provided will be ignored.}
}
\value{
the "control.family" argument to be passed to inla, a list of "control.family" arguments for each model in the hierarchical measurement error model.
}
\description{
Make "control.family" argument for passing to the "inla" function
}
\examples{
\dontshow{if (requireNamespace('INLA')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
make_inlamemi_control.family(
  family_moi = "gaussian",
  error_type = c("berkson", "classical"),
  prior.prec.moi = c(10, 9),
  prior.prec.berkson = c(10, 9),
  prior.prec.classical = c(10, 9),
  prior.prec.imp = c(10, 9),
  initial.prec.moi = 1,
  initial.prec.berkson = 1,
  initial.prec.classical = 1,
  initial.prec.imp = 1)

make_inlamemi_control.family(
  family_moi = "weibull.surv",
  error_type = c("classical", "missing"),
  control.family.moi =
    list(hyper = list(alpha = list(param = 0.01,
                                   initial = log(1.4),
                                   fixed = FALSE))),
  prior.prec.classical = c(0.5, 0.5),
  prior.prec.imp = c(0.5, 0.5),
  initial.prec.classical = 2.8,
  initial.prec.imp = 1)
\dontshow{\}) # examplesIf}
}
