% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{bru_safe_sp}
\alias{bru_safe_sp}
\title{Check for potential \code{sp} version compatibility issues}
\usage{
bru_safe_sp(quietly = FALSE, force = FALSE, minimum_version = "1.4-5")
}
\arguments{
\item{quietly}{logical; if \code{TRUE}, prints diagnostic messages. Default \code{FALSE}}

\item{force}{logical; If \code{rgdal} is unavailable
and evolution status is less that \code{2L}, return \code{FALSE} if \code{force} is \code{FALSE}.
If \code{force} is \code{TRUE}, return \code{TRUE} if the package configuration is safe,
potentially after forcing the evolution status to \code{2L}.
Default \code{FALSE}}

\item{minimum_version}{character; the minimum required INLA version.
Default 1.4-5 (should always match the requirement in the package
DESCRIPTION)}
}
\value{
Returns (invisibly) \code{FALSE} if a potential issue is detected, and give a
message if \code{quietly} is \code{FALSE}. Otherwise returns \code{TRUE}
}
\description{
Loads the sp package with \code{requireNamespace("sp", quietly = TRUE)}, and
checks and optionally sets the \code{sp} evolution status flag if \code{rgdal} is unavailable.
}
\examples{
\dontrun{
if (bru_safe_sp()) {
  # Run sp dependent calculations
}
}

}
