% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{gg.SpatialPixels}
\alias{gg.SpatialPixels}
\title{Geom for SpatialPixels objects}
\usage{
\method{gg}{SpatialPixels}(data, ...)
}
\arguments{
\item{data}{A \link{SpatialPixels} object.}

\item{...}{Arguments passed on to \link{geom_tile}.}
}
\value{
A \link{geom_tile} return value.
}
\description{
Uses \link{geom_point} to plot the pixel centers.
}
\examples{

# Load Gorilla data

data(gorillas)

# Turn elevation covariate into SpatialPixels
pxl = SpatialPixels(SpatialPoints(gorillas$gcov$elevation))

# Plot the pixel centers
ggplot() + gg(pxl, size = 0.1)
}
\seealso{
Other geomes for spatial data: \code{\link{gg.SpatialGridDataFrame}},
  \code{\link{gg.SpatialLines}},
  \code{\link{gg.SpatialPixelsDataFrame}},
  \code{\link{gg.SpatialPoints}},
  \code{\link{gg.SpatialPolygons}}, \code{\link{gg}},
  \code{\link{gm}}
}
