% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeBlkDesMat.R
\name{makeBlkDesMat}
\alias{makeBlkDesMat}
\title{Construct Block Design Matrix}
\usage{
makeBlkDesMat(design.df, blkTerm)
}
\arguments{
\item{design.df}{a data frame containing the experimental design. Requires
every column be a \code{\link{factor}}.}

\item{blkTerm}{a vector of character containing the labels of the block
terms in the model generated by the \code{\link{terms}}.}
}
\value{
A list of the binary matrices.
}
\description{
Construct a binary matrix representing the block design. The rows are
corresponding to the observations and the columns are corresponding to the
blocks.
}
\examples{


design1 <- local({ 
  Ani = as.factor(LETTERS[c(1,2,3,4,
                            5,6,7,8)])
  Trt = as.factor(letters[c(1,1,1,1,
                            2,2,2,2)])
  data.frame(Ani, Trt)
})

blk.str = "Ani*Trt"
    
rT = terms(as.formula(paste("~", blk.str, sep = "")), keep.order = TRUE) 

blkTerm = attr(rT,"term.labels")
Z = makeBlkDesMat(design1, blkTerm)



}
\seealso{
\code{\link{terms}}
}
\author{
Kevin Chang
}
