\name{getCoefVC}
\alias{getCoefVC.onePhase}
\alias{getCoefVC.twoPhase}
\title{
Get Variance Components' Coefficients and Mean Squares for Single-Phase or Two-Phase Experiments
}
\description{
Compute the variance components' coefficients and corresponding to random effects in the expected mean squares of ANOVA table in single-phase or two-phase experiments. These coefficients are then inserted to a matrix where the rows correspond to each source of variation and column correspond to DF and every variance component. The mean squares is calculated if the \code{response} argument is used.
}
\usage{
getCoefVC.onePhase(Pb, design.df, v.mat, response, table.legend, decimal, digits)
getCoefVC.twoPhase(Pb, design.df, v.mat, response, table.legend, decimal, digits)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{Pb}{
a list of matrices generated by \code{\link{infoDecompMat}} function.
}
 \item{design.df}{
a data frame containing the experimental design. Requires every column be a \code{\link{factor}}.
}
  \item{v.mat}{
a list of matrix generated by \code{\link{getVMat.onePhase}} or \code{\link{getVMat.twoPhase}}.
}
  \item{response}{
a numeric vector contains the responses from the experiment. 
}
 \item{table.legend}{
a logical allows users to generate a legend for the variance components of the ANOVA table for large designs. Default is \code{FALSE}, resulting in the use of original block factor names.   
}
\item{decimal}{
a logical allows users to display the coefficients as the decimals. Default is \code{FALSE}, resulting in the use of \code{fractions}.    
}
 \item{digits}{
a integer indicating the number of decimal places. Default is 2, resulting in 2 decimal places.  
}
}
\details{
The main purpose of this function is to combine the matrices presenting every source of variation of the ANOVA table and the variance matrix to compute the  coefficients of the variance components.

The complication arise in giving the row names of the matrix for the source of variation in the ANOVA table.
}
\value{
A matrix containing the characters. 
}
\author{
Kevin Chang
}
\examples{
design1 <- local({ 
  Ani <- as.factor(LETTERS[c(1,2,3,4,
                            5,6,7,8)])
  Trt <- as.factor(letters[c(1,1,1,1,
                            2,2,2,2)])
  data.frame(Ani, Trt)
})

blk.str <- "Ani"
    
rT <- terms(as.formula(paste("~", blk.str, sep = "")), keep.order = TRUE) 
blkTerm <- attr(rT,"term.labels")
     
Z <- makeBlkDesMat(design1, blkTerm)

trt.str <- "Trt"              
fT <- terms(as.formula(paste("~", trt.str, sep = "")), keep.order = TRUE)  #fixed terms

trtTerm <- attr(fT, "term.labels")
effectsMatrix <- attr(fT, "factor")        

T <- makeContrMat(design1, trtTerm, effectsMatrix, contr.vec = NA)

N =  makeOverDesMat(design1, trtTerm)

Replist = getTrtRep(design1, trtTerm)   
 
Rep <- Replist$Rep
trt.Sca <- Replist$Sca
    
effFactors = lapply(makeOrthProjectors(Z), function(z) 
      getEffFactor(z, T, N, Rep, trt.Sca))

#Now construct variance matrices
Pb <- effFactors[sort(1:length(effFactors), decreasing=TRUE)]

v.mat <- getVMat.onePhase(Z.Phase1 = Z, design.df = design.df, var.comp = NA)
    
getCoefVC.onePhase(Pb = Pb, design.df = design1, v.mat = v.mat, response = NA, 
    table.legend = FALSE, decimal = FALSE, digit = 2)

}
