\name{adjustEffectNames}
\alias{adjustEffectNames}
\title{
Adjust the Effects' Names
}
\description{
Adjust for appropriate syntax describing the effects matching the structural formula.
}
\usage{
adjustEffectNames(effectsMatrix, effectNames)
}
\arguments{
\item{effectNames}{
a vector of character containing the labels of the treatment or block terms in the model generated by the \code{\link{terms}}.
}
\item{effectsMatrix}{
a matrix of variables by terms showing which variables appear in which terms generated by the \code{\link{terms}}.
}
}

\value{
A vector of character containing the labels of the terms in the model with appropriate syntax describing the effects. 
}
\author{
Kevin Chang
}
\examples{
str.for = "A*(B/E/C)*D"
effectsMatrix= attr(terms(as.formula(paste("~", str.for)), keep.order = TRUE) , "factors")
effectNames =  attr(terms(as.formula(paste("~", str.for)), keep.order = TRUE) , "term.labels")

adjustEffectNames(effectsMatrix, effectNames) 
}
