% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{graph_from_adjacency_matrix}
\alias{graph_from_adjacency_matrix}
\alias{adjmatrix2graph}
\title{Creating igraph graphs from adjacency matrices}
\usage{
graph_from_adjacency_matrix(
  adjmatrix,
  mode = c("directed", "undirected", "max", "min", "upper", "lower", "plus"),
  weighted = NULL,
  diag = TRUE,
  add.colnames = NULL,
  add.rownames = NA
)
}
\arguments{
\item{adjmatrix}{A square adjacency matrix. From igraph version 0.5.1 this
can be a sparse matrix created with the Matrix package.}

\item{mode}{Character scalar, specifies how igraph should interpret the supplied matrix.
See also the weighted argument, the interpretation depends on that too.
Possible values are: directed, undirected, upper, lower, max, min, plus.}

\item{weighted}{This argument specifies whether to create a weighted graph from an adjacency matrix.
If it is NULL then an unweighted graph is created and the elements of the adjacency matrix gives the
number of edges between the vertices. If it is a character constant then for every non-zero matrix
entry an edge is created and the value of the entry is added as an edge attribute named by the weighted argument.
If it is TRUE then a weighted graph is created and the name of the edge attribute will be weight.}

\item{diag}{Logical scalar, whether to include the diagonal of the matrix in the calculation.
If this is FALSE then the diagonal is zerod out first.}

\item{add.colnames}{Character scalar, whether to add the column names as vertex attributes.
If it is ‘NULL’ (the default) then, if present, column names are added as vertex attribute ‘name’.
If ‘NA’ then they will not be added. If a character constant, then it gives the name of the vertex attribute to add.}

\item{add.rownames}{Character scalar, whether to add the row names as vertex attributes.
Possible values the same as the previous argument. By default row names are not added.
If ‘add.rownames’ and ‘add.colnames’ specify the same vertex attribute, then the former is ignored.}
}
\value{
An igraph graph object.
}
\description{
This function and all of its descriptions have been obtained from the igraph package.
}
\examples{
MyData <- coexpression.adjacency
My_graph <- graph_from_adjacency_matrix(MyData)
}
\seealso{
\code{\link[igraph]{graph_from_adjacency_matrix}} for a complete description on this function

Other network_reconstruction functions: 
\code{\link{graph_from_data_frame}()},
\code{\link{graph_from_incidence_matrix}()},
\code{\link{sif2igraph}()}
}
\concept{network_reconstruction functions}
\keyword{graph_from_adjacencymatrices}
