% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ine_data.R
\name{get_ine_data}
\alias{get_ine_data}
\title{Get data from the INE API}
\usage{
get_ine_data(
  indicator,
  lang = "PT",
  expected.duration = FALSE,
  max_cells = 30000,
  ...
)
}
\arguments{
\item{indicator}{INE indicator ID as a 7 character string. Example: "0010003".}

\item{lang}{One of "PT" or "EN". Default is "PT".}

\item{expected.duration}{If TRUE, prints the expected remaining duration in the console.}

\item{max_cells}{Integer smaller than or equal to 40000, the maximum number of cells allowed in each API call.
Default value of 30000}

\item{...}{Values for each Dimension of the indicator.
Each parameter should be in the form dimN, with N one of \{1, ..., Nº of dimensions\}.
If one of the dimensions is not included, output includes all values for that dimension.}
}
\value{
tidy data frame for the given indicator.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} \cr
Return tidy data frames from Instituto Nacional de Estatística API
}
\details{
Extraction time can be very high (many hours) for indicators with many dimensions and/or many unique values. E.g. Indicator "0008206 - Deaths by Place of residence, Sex, Age group and Death cause, Annual" will take many hours to extract.
}
\examples{
#A simple example. Returns the complete dataset.
get_ine_data("0011823")
# A more complex example. Returns a subset of the dataset.
\donttest{
get_ine_data("0008206", dim1 = "S7A1996", dim2 = c("11","111"),
             dim4 = c(1,19), dim5 = "TLES")
}
}
\seealso{
\code{\link[=get_dim_values]{get_dim_values()}} can be used to identify the values to be passed to \emph{dimN} parameters, in the variable categ_cod.
See \href{https://c-matos.github.io/ineptR/articles/use_cases.html}{this vignette} for further clarification on how to obtain only a subset of the data.
}
