% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.R
\name{incprops}
\alias{incprops}
\title{Incidence and incidence difference statistics from trinomial prevalences of HIV and recency}
\usage{
incprops(PrevH, RSE_PrevH, PrevR, RSE_PrevR, Boot = FALSE,
  BS_Count = 10000, alpha = 0.05, BMest = "same.test", MDRI,
  RSE_MDRI, FRR, RSE_FRR, BigT = 730, Covar_HR = 0)
}
\arguments{
\item{PrevH}{Prevalence of HIV (vector/integer).}

\item{RSE_PrevH}{Relative Standard Error (RSE) of estimate for population prevalence of HIV (vector/integer).}

\item{PrevR}{Proportion of persons found to be 'recent' by biomarker assay among total persons found positive for HIV (vector/integer).}

\item{RSE_PrevR}{Relative Standard Error (RSE) of estimate for population proportion of those testing positive for HIV who have been infected recently (vector/integer).}

\item{Boot}{True/False variable indicating whether variance of point estimates is to be calculated by Empirical Bootstrapping (TRUE) or Delta Method (FALSE), the default setting.}

\item{BS_Count}{Specifies number of bootstrap samples for bootstrapped confidence intervals of incidence.}

\item{alpha}{test rejection threshold.}

\item{BMest}{Biomarker estimation by one the 3 options 'same.test'(=default), 'FRR.indep', 'MDRI.FRR.indep' (string).}

\item{MDRI}{mean duration of recent infection [days] (vector/integer).}

\item{RSE_MDRI}{Relative standard error of MDRI [days] (vector/integer).}

\item{FRR}{False recent rate (vector/integer).}

\item{RSE_FRR}{Relative standard error of FRR (vector/integer).}

\item{BigT}{post-infection time cut-off true vs false recent [days] default 730 days (integer).}

\item{Covar_HR}{Covariance of probability of being positive and being categorized recent from survey (vector/integer). Note that as the variances of PrevH and PrevR are often quite small, only a suitably commensurate covariance will enable the inversion of the bootstrap covariance matrix for random number generation to proceed without error.}
}
\value{
Returns incidence and incidence difference statistics, annualised risk and implied CIs on test characteristics.
}
\description{
Incidence and incidence difference statistics from trinomial prevalences of HIV and recency
}
\details{
Implements assay-based incidence estimation through cross-sectional prevalence and recency of infection tests as described by Kassanjee, et al. 'A new general biomarker-based incidence estimator,' \emph{Epidemiology} (2012). Function parameters must be specified to include assay test characteristics and survey results as proportions. Confidence intervals are computed via Delta method approximation, except when Boot=TRUE is specified, in which case confidence intervals are generated by empirical bootstrap resampling. Inputs must be in appropriate ranges for appropriate units. Extreme input values may make calculation impossible, and if entered will elicit error notices.

The package contains long form documentation in the form of vignettes that cover the use of the main fucntions. Use browseVignettes(package="inctools") to access them.
}
\examples{
incprops(PrevH = 0.20, RSE_PrevH = 0.028, PrevR = 0.10, RSE_PrevR = 0.09,
         BS_Count = 10000, Boot = TRUE, MDRI = 200, RSE_MDRI = 0.05,
         FRR = 0.01,
         RSE_FRR = 0.2, BigT = 730)


incprops(PrevH = c(0.20,0.21,0.18), RSE_PrevH = c(0.028,0.03,0.022),
         PrevR = c(0.10,0.13,0.12), RSE_PrevR = c(0.094,0.095,0.05),
         BS_Count = 10000, Boot = FALSE, BMest = 'MDRI.FRR.indep', MDRI = c(200,180,180),
         RSE_MDRI = c(0.05,0.07,0.06), FRR = c(0.01,0.009,0.02), RSE_FRR = c(0.2,0.2,0.1),
         BigT = 730)
}
