% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.R
\name{incpower}
\alias{incpower}
\title{Power and sample size calculation for assay-based incidence estimation}
\usage{
incpower(I1, I2, PrevH1, PrevH2, n1 = "both", n2 = "both", alpha = 0.05,
  Power = 0.8, SS = "out", CR = 1, DE_H = 1, DE_R = 1,
  BMest = "same.test", MDRI, RSE_MDRI, FRR, RSE_FRR, BigT = 730)
}
\arguments{
\item{I1}{Predicted incidence of HIV in survey 1.}

\item{I2}{Predicted incidence of HIV in survey 2.}

\item{PrevH1}{Predicted prevalence of HIV in survey 1.}

\item{PrevH2}{Predicted prevalence of HIV in survey 2.}

\item{n1}{Sample size for survey 1. If equal sample sizes for both surveys are desired at a given power level, both n1 and n2 must have value 'both', which is the default.}

\item{n2}{Sample size for survey 2. If equal sample sizes for both surveys are desired at a given power level, both n1 and n2 must have value 'both', which is the default.}

\item{alpha}{Significance level for test (default alpha=0.05).}

\item{Power}{Desired power used to calculate a sample size for the surveys. Default is 0.80, meaning the function outputs the necessary sample size to achieve stated power for a test of differences in incidence. If Power is set to 'out', function will return power of detecting a difference in incidences for given sample size inputs.}

\item{SS}{Sample size. Default is 'out', meaning the function takes a power argument and outputs a common sample size needed to achieve power level for test of differences for incidence. If power is desired for a given sample size, parameter value is irrelevant; however, values for n1 and n2 must be specified.}

\item{CR}{Coverage rate (0-1).}

\item{DE_H}{Design effect of HIV prevalence test (vector/integer). If a single value is specified, that value is assumed to be the value for both surveys.}

\item{DE_R}{Design effect of recency test (vector/integer). If a single value is specified, that value is assumed to be the value for both surveys.}

\item{BMest}{Biomarker test parameter (MDRI, FRR, and RSE) estimation by one the 3 options 'same.test'(default), 'FRR.indep', 'MDRI.FRR.indep' (string).}

\item{MDRI}{mean duration of recent infection [days] (vector/integer). If a single value is specified, that value is assumed to be the value for both surveys.}

\item{RSE_MDRI}{Relative standard error of MDRI [days] (vector/integer). If a single value is specified, that value is assumed to be the value for both surveys.}

\item{FRR}{False recent rate (vector/integer). If a single value is specified, that value is assumed to be the value for both surveys.}

\item{RSE_FRR}{Relative standard error of FRR (vector/integer). If a single value is specified, that value is assumed to be the value for both surveys.}

\item{BigT}{Post-infection time cut-off (days). Default 730. If a single value is specified, that value is assumed to be the value for both surveys.}
}
\value{
Common sample size of two surveys--or the sample size of one survey given the other has already been completed--necessary to achieve a given power level for testing a null hypothesis that the incidence rates are identical between populations; alternatively, the power of said test under a particular sample size scenario. Function also returns implied statistics from input values on paramters, confidence limits, and population counts.
}
\description{
Power and sample size calculation for assay-based incidence estimation
}
\details{
The package contains long form documentation in the form of vignettes that cover the use of the main fucntions. Use browseVignettes(package="inctools") to access them.
}
\examples{
incpower(I1 = 0.05, I2 = 0.03, PrevH1 = 0.20, PrevH2 = 0.20,
n1 = 5000, n2 = 5000, alpha = 0.05, Power = "out", SS = NULL,
DE_H = c(1,1.1), DE_R = 1, BMest = 'same.test', MDRI = 200,
RSE_MDRI = 0.05, FRR = 0.01, RSE_FRR = 0.20, BigT = 730)


incpower(I1 = 0.05, I2 = 0.03, PrevH1 = 0.20, PrevH2 = 0.20,
alpha = 0.05, Power = 0.80, SS = "out", DE_H = 1, DE_R = 1,
BMest = 'FRR.indep', MDRI = 200, RSE_MDRI = 0.05,
FRR = c(0.01,0.009), RSE_FRR = c(0.20,0.21), BigT = 730)
}
