% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curveball.R
\name{curveball}
\alias{curveball}
\title{Randomize a binary matrix using the curveball algorithm}
\usage{
curveball(M, trades = 5 * nrow(M))
}
\arguments{
\item{M}{a binary matrix}

\item{trades}{integer: number of trades; the default is 5 * nrow(M) (approx. mixing time)}
}
\value{
A random binary matrix with same row sums and column sums as M
}
\description{
\code{curveball} randomizes a binary matrix, preserving the row and column sums
}
\details{
Strona et al. (2014) provided an initial implementation of the Curveball algorithm in R. \code{curveball()} is a modified R
implementation that is slightly more efficient. For an even more efficient algorithm, see \code{backbone::fastball()}.
}
\examples{
M <- incidence.from.probability(5,5,.5)  #A matrix
Mrand <- curveball(M)  #Random matrix with same row/col sums
all.equal(rowSums(M), rowSums(curveball(M)))
all.equal(colSums(M), colSums(curveball(M)))
}
\references{
{Strona, Giovanni, Domenico Nappo, Francesco Boccacci, Simone Fattorini, and Jesus San-Miguel-Ayanz. 2014. A Fast and Unbiased Procedure to Randomize Ecological Binary Matrices with Fixed Row and Column Totals. \emph{Nature Communications, 5}, 4114. \doi{10.1038/ncomms5114}}

{Godard, Karl and Neal, Zachary P. 2022. fastball: A fast algorithm to sample bipartite graphs with fixed degree sequences. \href{https://arxiv.org/abs/2112.04017}{\emph{arXiv:2112.04017}}}
}
