% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.R
\name{incidence}
\alias{incidence}
\title{Compute the incidence of events}
\usage{
incidence(
  x,
  date_index,
  groups = NULL,
  counts = NULL,
  count_names_to = "count_variable",
  count_values_to = "count",
  date_names_to = "date_index",
  rm_na_dates = TRUE,
  interval = NULL,
  offset = NULL,
  ...
)
}
\arguments{
\item{x}{A data frame object representing a linelist or pre-aggregated dataset.}

\item{date_index}{\verb{[character]}

The time index(es) of the given data.

This should be the name(s) corresponding to the desired date column(s) in x.

A name vector can be used for convenient relabelling of the resultant output.

Multiple indices only make sense when  \code{x} is a linelist.}

\item{groups}{\verb{[character]}

An optional vector giving the names of the groups of observations for which
incidence should be grouped.}

\item{counts}{\verb{[character]}

The count variables of the given data.  If NULL (default) the data is taken
to be a linelist of individual observations.}

\item{count_names_to}{\verb{[character]}

The column to create which will store the \code{counts} column names provided that
\code{counts} is not NULL.}

\item{count_values_to}{\verb{[character]}

The name of the column to store the resultant count values in.}

\item{date_names_to}{\verb{[character]}

The name of the column to store the date variables in.}

\item{rm_na_dates}{\verb{[logical]}

Should \code{NA} dates be removed prior to aggregation?}

\item{interval}{An optional scalar integer or string indicating the (fixed) size of
the desired time interval you wish to use for for computing the incidence.

Defaults to NULL in which case the date_index columns are left unchanged.

Numeric values are coerced to integer and treated as a number of days to
group.

Text strings can be one of:

\if{html}{\out{<div class="sourceCode">}}\preformatted{* day or daily
* week(s) or weekly
* epiweek(s)
* isoweek(s)
* month(s) or monthly
* yearmonth(s)
* quarter(s) or quarterly
* yearquarter(s)
* year(s) or yearly
}\if{html}{\out{</div>}}

More details can be found in the "Interval specification" section.}

\item{offset}{Only applicable when \code{interval} is not NULL.

An optional scalar integer or date indicating the value you wish to start
counting periods from relative to the Unix Epoch:
\itemize{
\item Default value of NULL corresponds to 0L.
\item For other integer values this is stored scaled by \code{n}
(\code{offset <- as.integer(offset) \%\% n}).
\item For date values this is first converted to an integer offset
(\code{offset <- floor(as.numeric(offset))}) and then scaled via \code{n} as above.
}}

\item{...}{Not currently used.}
}
\value{
An object of class \verb{<incidence2, data.frame>}.
}
\description{
\code{incidence()} calculates event the \emph{incidence} of different events across
specified time periods and groupings.
}
\details{
\verb{<incidence2>} objects are a sub class of data frame with some
additional invariants. That is, an \verb{<incidence2>} object must:
\itemize{
\item have one column representing the date index (this does not need to be a
\code{date} object but must have an inherent ordering over time);
\item have one column representing the count variable (i.e. what is being
counted) and one variable representing the associated count;
\item have zero or more columns representing groups;
\item not have duplicated rows with regards to the date and group variables.
}
}
\section{Interval specification}{
Where \code{interval} is specified, \code{incidence()}, predominantly uses the
\href{https://cran.r-project.org/package=grates}{\code{grates}} package to generate
appropriate date groupings. The grouping used depends on the value of
\code{interval}. This can be specified as either an integer value or a string
corresponding to one of the classes:
\itemize{
\item integer values:                     \code{\link[grates:new_period]{<grates_period>}} object, grouped by the specified number of days.
\item day, daily:                         \code{\link[base:Dates]{<Date>}} objects.
\item week(s), weekly, isoweek:           \code{\link[grates:isoweek]{<grates_isoweek>}} objects.
\item epiweek(s):                         \code{\link[grates:epiweek]{<grates_epiweek>}} objects.
\item month(s), monthly, yearmonth:       \code{\link[grates:yearmonth]{<grates_yearmonth>}} objects.
\item quarter(s), quarterly, yearquarter: \code{\link[grates:yearquarter]{<grates_yearquarter>}} objects.
\item year(s) and yearly:                 \code{\link[grates:year]{<grates_year>}} objects.
}

For "day" or "daily" interval, we provide a thin wrapper around \code{as.Date()}
that ensures the underlying data are whole numbers and that time zones are
respected. Note that additional arguments are not forwarded to \code{as.Date()}
so for greater flexibility users are advised to modifying your input prior to
calling \code{incidence()}.
}

\examples{
\dontshow{data.table::setDTthreads(2)}
if (requireNamespace("outbreaks", quietly = TRUE)) {
\dontshow{withAutoprint(\{}
    data(ebola_sim_clean, package = "outbreaks")
    dat <- ebola_sim_clean$linelist
    incidence(dat, "date_of_onset")
    incidence(dat, "date_of_onset", groups = c("gender", "hospital"))
\dontshow{\})}
}

}
\seealso{
\code{browseVignettes("grates")} for more details on the grate object classes.
}
