% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-utility.R
\name{cv}
\alias{cv}
\title{Compute the percentage coefficient of variation,
(in a scale from 0 to 100).}
\usage{
cv(x, na.rm = FALSE)
}
\arguments{
\item{x}{Numeric vector.}

\item{na.rm}{Logical, should NA value(s) be removed (FALSE by default)?}
}
\value{
Numeric vector of length 1 with coefficient of variation.
}
\description{
The coefficient of variation is computed as:
\eqn{\frac{\sigma(x)}{\bar{x}}*100}, with:
\itemize{
\item{\eqn{\sigma(x)}: }{standard deviation of \code{x}}
\item{\eqn{\bar{x}}: }{arithmetic mean of \code{x}}
}
}
\examples{
# coefficient of variation of normal distribution tends to 100\%
cv(rnorm(n = 1000, mean = 1, sd = 1))
}
\seealso{
Other stats utility functions: 
\code{\link{geomCV}()},
\code{\link{geomMean}()},
\code{\link{geomSD}()},
\code{\link{geomSE}()},
\code{\link{se}()}
}
\author{
Laure Cougnaud
}
\concept{stats utility functions}
