% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_impute.R
\name{plot_impute}
\alias{plot_impute}
\title{Plot imputations}
\usage{
plot_impute(dataIn = NULL, smps = "mcar", methods = c("na.approx",
  "na.interp", "na.interpolation", "na.locf", "na.mean"), methodPath = NULL,
  blck = 50, blckper = TRUE, missPercent = 50, showmiss = FALSE,
  addl_arg = NULL)
}
\arguments{
\item{dataIn}{input \code{\link[stats]{ts}} for testing, defaults to \code{\link[datasets]{nottem}}}

\item{smps}{chr string indicating sampling type for generating missing data, see details}

\item{methods}{chr string of imputation methods to use, one to many.  A user-supplied function can be included if \code{MethodPath} is used.}

\item{methodPath}{chr string of location of script containing one or more functions for the proposed imputation method(s)}

\item{blck}{numeric indicating block sizes as a percentage of the sample size for the missing data, applies only if \code{smps = 'mcar'}}

\item{blckper}{logical indicating if the value passed to \code{blck} is a percentage of the sample size for missing data, otherwise \code{blck} indicates number of observations}

\item{missPercent}{numeric for percent of missing values to be considered}

\item{showmiss}{logical if actual missing values are plotted}

\item{addl_arg}{arguments passed to other imputation methods as a list of lists, see details.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object showing the imputed data for each method.  Imputed data are colored as 'filled'.  Actual missing data can be added to the plot if \code{showmiss = TRUE}.
}
\description{
Plot imputations for data from multiple methods
}
\details{
See the documentation for \code{\link{impute_errors}} for an explanation of the arguments.
}
\examples{
plot_impute()
}

