% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoItALL.R
\name{calc_all}
\alias{calc_all}
\title{Calculate and Impute REE missing data and anomalies.}
\usage{
calc_all(data, prefix = NULL, suffix = NULL, method = PalmeOneill2014CI)
}
\arguments{
\item{data}{A data frame containing REE data}

\item{prefix}{a string. A prefix in the columns names e.g 'Whole_rock_La', where 'Whole_rock_' is the prefix}

\item{suffix}{a string. A suffix in the columns names e.g 'La_ppm', where '_ppm' is the suffix}

\item{method}{an option from: 'PalmeOneill2014CI', 'Oneill2014Mantle', 'McDonough1995CI'}
}
\value{
A data frame. Includes imputed REE, model metrics, and calculated variables.
}
\description{
This is a wrapper for data \%>\% model_REE() \%>\% impute_REE \%>\% add_parameters()
}
\examples{

testing_data \%>\% calc_all(prefix = 'Zr_', suffix = '_ppm')


}
