% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_impala.R
\name{compute}
\alias{compute}
\alias{compute.tbl_impala}
\alias{collect}
\alias{collect.tbl_impala}
\alias{collapse}
\alias{collapse.tbl_impala}
\title{Force execution of an Impala query}
\usage{
\method{compute}{tbl_impala}(
  x,
  name,
  temporary = TRUE,
  unique_indexes = NULL,
  indexes = NULL,
  analyze = FALSE,
  external = FALSE,
  overwrite = FALSE,
  force = FALSE,
  field_terminator = NULL,
  line_terminator = NULL,
  file_format = NULL,
  ...
)

\method{collect}{tbl_impala}(x, ..., n = Inf, warn_incomplete = TRUE)

\method{collapse}{tbl_impala}(x, vars = NULL, ...)
}
\arguments{
\item{x}{an object with class \code{tbl_impala}}

\item{name}{the name for the new Impala table}

\item{temporary}{must be set to \code{FALSE}}

\item{unique_indexes}{not used}

\item{indexes}{not used}

\item{analyze}{whether to run \code{COMPUTE STATS} after adding data to the
new table}

\item{external}{whether the new table will be externally managed}

\item{overwrite}{whether to overwrite existing table data (currently ignored)}

\item{force}{whether to silently fail if the table already exists}

\item{field_terminator}{the deliminter to use between fields in text file
data. Defaults to the ASCII control-A (hex 01) character}

\item{line_terminator}{the line terminator. Defaults to \code{"\n"}}

\item{file_format}{the storage format to use. Options are \code{"TEXTFILE"}
(default) and \code{"PARQUET"}}

\item{...}{other arguments passed on to methods}

\item{n}{the number of rows to return}

\item{warn_incomplete}{whether to issue a warning if not all rows retrieved}

\item{vars}{not used}
}
\description{
\describe{ \item{\code{compute()}}{Executes the query and stores
the result in a new Impala table} \item{\code{collect()}}{Executes the query
and returns the result to R as a data frame \code{tbl}}
\item{\code{collapse()}}{Generates the query for later execution} }
}
\note{
Impala does not support temporary tables. When using \code{compute()}
  to store results in an Impala table, you must set \code{temporary = FALSE}.
}
