% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_dscore.R
\name{multi_dscore}
\alias{multi_dscore}
\title{Compute and plot multiple D-scores}
\usage{
multi_dscore(data, ds = c("built-in", "error-inflation"))
}
\arguments{
\item{data}{Dataframe of class \code{iat_clean}.}

\item{ds}{String. Indicates which D-score to compute. \code{built-in} compute
only \emph{D-score} with the built-in error correction (D1 and D2),
\code{error-inflation} compute the \emph{D-score}s without built-in
correction (D3 to D6).}
}
\value{
A list. The first object is a dataframe containing all the computed
 Dscores. The second object is a \code{ggplot} object, depicting the
 distribution of the \emph{D-score}s through violin plots.
}
\description{
Compute and plot multiple \emph{D-score}s.
}
\examples{
\donttest{
 # Compute multiple IAT D-scores
  data("raw_data") # import data
  iat_cleandata <- clean_iat(raw_data, sbj_id = "Participant",
                          block_id = "blockcode",
                          mapA_practice = "practice.iat.Milkbad",
                          mapA_test = "test.iat.Milkbad",
                          mapB_practice = "practice.iat.Milkgood",
                          mapB_test = "test.iat.Milkgood",
                          latency_id = "latency",
                          accuracy_id = "correct",
                          trial_id = "trialcode",
                          trial_eliminate = c("reminder", "reminder1"),
                          demo_id = "blockcode",
                          trial_demo = "demo")
  iat_data <- iat_cleandata[[1]]

  # compute the mulitple scores and prepare the graphs for the built-in
  # strategies

  multiple_scores <- multi_dscore(iat_data, ds = "built-in")

  data_multiple <- multiple_scores$dscores # store the D-score in a dataframe

  # plot the results
  multiple_scores$graph
  }
}
