% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro.R
\name{hydro}
\alias{hydro}
\title{Hydrological data from IMGW}
\usage{
hydro(interval, year, coords = FALSE, value = "H", station = NULL,
  col_names = "short", ...)
}
\arguments{
\item{interval}{temporal resolution of the data ("daily" , "monthly", or "semiannual_and_annual")}

\item{year}{vector of years (e.g., 1966:2000)}

\item{coords}{add coordinates of the stations (logical value TRUE or FALSE)}

\item{value}{type of data (can be: state - "H" (default), flow - "Q", or temperature - "T")}

\item{station}{vector of hydrological stations danepubliczne.imgw.pl can be name of station CAPITAL LETTERS(character)
It accepts names (characters in CAPITAL LETTERS) or stations' IDs (numeric)}

\item{col_names}{three types of column names possible: "short" - default, values with shorten names, "full" - full English description, "polish" - original names in the dataset}

\item{...}{other parameters that may be passed to the 'shortening' function that shortens column names}
}
\description{
Downloading hourly, daily, and monthly hydrological data from the SYNOP / CLIMATE / PRECIP stations available in the danepubliczne.imgw.pl collection
}
\examples{
\donttest{
  x <- hydro("monthly", year = 1999)
  head(x)
}
}
