% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{get.locations}
\alias{get.locations}
\title{Return coordinates of subset of pixels}
\usage{
get.locations(im, condition)
}
\arguments{
\item{im}{the image}

\item{condition}{a function that takes scalars and returns logicals}
}
\value{
coordinates of all pixels such that condition(pixel) == TRUE
}
\description{
Typical use case: you want the coordinates of all pixels with a value above a certain threshold
}
\examples{
\dontshow{cimg.limit.openmp()}
im <- as.cimg(function(x,y) x+y,10,10)
get.locations(im,function(v) v < 4)
get.locations(im,function(v) v^2 + 3*v - 2 < 30)

}
\author{
Simon Barthelme
}
