% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{FFT}
\alias{FFT}
\title{Compute the Discrete Fourier Transform of an image}
\usage{
FFT(im.real, im.imag, inverse = FALSE)
}
\arguments{
\item{im.real}{The real part of the input (an image)}

\item{im.imag}{The imaginary part (also an image. If missing, assume the signal is real).}

\item{inverse}{If true compute the inverse FFT (default: FALSE)}
}
\value{
a list with components "real" (an image) and "imag" (an image), corresponding to the real and imaginary parts of the transform
}
\description{
This function is equivalent to R's builtin fft, up to normalisation (R's version is unnormalised, this one is). It calls CImg's implementation.
Important note: FFT will compute a multidimensional Fast Fourier Transform, using as many dimensions as you have in the image, meaning that if you have a colour video, it will perform a 4D FFT. If you want to compute separate FFTs across channels, use imsplit.
}
\examples{

im <- as.cimg(function(x,y) sin(x/5)+cos(x/4)*sin(y/2),128,128)
ff <- FFT(im)
plot(ff$real,main="Real part of the transform")
plot(ff$imag,main="Imaginary part of the transform")
sqrt(ff$real^2+ff$imag^2) \%>\% plot(main="Power spectrum")
#Check that we do get our image back
check <- FFT(ff$real,ff$imag,inverse=TRUE)$real #Should be the same as original
mean((check-im)^2)

}
\author{
Simon Barthelme
}

