% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rotate_xy}
\alias{rotate_xy}
\title{Rotate image by an arbitrary angle, around a center point.}
\usage{
rotate_xy(im, angle, cx, cy, zoom = 1, interpolation = 1L,
  boundary_conditions = 0L)
}
\arguments{
\item{im}{an image}

\item{angle}{Rotation angle, in degrees.}

\item{cx}{X-coordinate of the rotation center.}

\item{cy}{Y-coordinate of the rotation center.}

\item{zoom}{Zoom factor.}

\item{interpolation}{Interpolation type. 0=nearest | 1=linear | 2=cubic}

\item{boundary_conditions}{Boundary conditions. 0=dirichlet | 1=neumann | 2=periodic}
}
\description{
Rotate image by an arbitrary angle, around a center point.
}
\examples{
rotate_xy(boats,30,200,400) \%>\% plot
rotate_xy(boats,30,200,400,boundary=2) \%>\% plot
}

