% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{erode}
\alias{dilate}
\alias{dilate_rect}
\alias{dilate_square}
\alias{erode}
\alias{erode_rect}
\alias{erode_square}
\alias{mclosing}
\alias{mclosing_square}
\alias{mopening}
\alias{mopening_square}
\title{Erode/dilate image by a structuring element.}
\usage{
erode(im, mask, boundary_conditions = TRUE, normalise = FALSE)

erode_rect(im, sx, sy, sz = 1L)

erode_square(im, size)

dilate(im, mask, boundary_conditions = TRUE, normalise = FALSE)

dilate_rect(im, sx, sy, sz = 1L)

dilate_square(im, size)

mopening(im, mask, boundary_conditions = TRUE, normalise = FALSE)

mopening_square(im, size)

mclosing_square(im, size)

mclosing(im, mask, boundary_conditions = TRUE, normalise = FALSE)
}
\arguments{
\item{im}{an image}

\item{mask}{Structuring element.}

\item{boundary_conditions}{Boundary conditions.}

\item{normalise}{Determines if the closing is locally normalised (default FALSE)}

\item{sx}{Width of the structuring element.}

\item{sy}{Height of the structuring element.}

\item{sz}{Depth of the structuring element.}

\item{size}{size of the structuring element.}
}
\description{
Erode/dilate image by a structuring element.
}
\section{Functions}{
\itemize{
\item \code{erode_rect}: Erode image by a rectangular structuring element of specified size.

\item \code{erode_square}: Erode image by a square structuring element of specified size.

\item \code{dilate}: Dilate image by a structuring element.

\item \code{dilate_rect}: Dilate image by a rectangular structuring element of specified size

\item \code{dilate_square}: Dilate image by a square structuring element of specified size

\item \code{mopening}: Morphological opening (erosion followed by dilation)

\item \code{mopening_square}: Morphological opening by a square element (erosion followed by dilation)

\item \code{mclosing_square}: Morphological closing by a square element (dilation followed by erosion)

\item \code{mclosing}: Morphological closing (dilation followed by erosion)
}}
\examples{
fname <- system.file('extdata/Leonardo_Birds.jpg',package='imager')
im <- load.image(fname) \%>\% grayscale
outline <- threshold(-im,"95\%")
plot(outline)
mask <- imfill(5,10,val=1) #Rectangular mask
plot(erode(outline,mask))
plot(erode_rect(outline,5,10)) #Same thing
plot(erode_square(outline,5))
plot(dilate(outline,mask))
plot(dilate_rect(outline,5,10))
plot(dilate_square(outline,5))
}

