% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_tags}
\alias{read_tags}
\title{Read TIFF tag information without actually reading the image array.}
\usage{
read_tags(path, all = TRUE)
}
\arguments{
\item{path}{A string. The path to the tiff file to read.}

\item{all}{TIFF files can contain multiple images. With \code{all = TRUE}, the
information about all images is returned in a list of lists. To just get
the information about some images, pass those image numbers to the \code{all}
parameter (see examples). \code{all = FALSE} is equivalent to \code{all = 1}.}
}
\value{
A list of lists.
}
\description{
TIFF files contain metadata about images in their \emph{TIFF tags}. This function
is for reading this information without reading the actual image.
}
\examples{
read_tags(system.file("img", "Rlogo.tif", package="ijtiff"))
read_tags(system.file("img", "2ch_ij.tif", package="ijtiff"))
read_tags(system.file("img", "2ch_ij.tif", package="ijtiff"), all = c(2, 4))

}
\seealso{
\code{\link[=read_tif]{read_tif()}}
}
\author{
Simon Urbanek, Kent Johnson, Rory Nolan.
}
