% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poster_html.R
\name{iheiddown_poster}
\alias{iheiddown_poster}
\alias{iheiddown_betterland}
\alias{iheiddown_betterport}
\title{Posterdown inspired HTML posters}
\source{
\href{https://github.com/brentthorne/posterdown}{\code{{Posterdown}}}
}
\usage{
iheiddown_poster(
  ...,
  template = system.file("rmarkdown", "templates", "iheiddown_poster", "resources",
    "template.html", package = "iheiddown"),
  css = NULL
)

iheiddown_betterland(
  ...,
  template = system.file("rmarkdown", "templates", "iheiddown_betterland", "resources",
    "template.html", package = "iheiddown"),
  css = NULL
)

iheiddown_betterport(
  ...,
  template = system.file("rmarkdown", "templates", "iheiddown_betterport", "resources",
    "template.html", package = "iheiddown"),
  css = NULL
)
}
\arguments{
\item{...}{Additional arguments to \code{rmarkdown::html_document}}

\item{template}{See \code{\link[pagedown]{html_paged}()}.}

\item{css}{See \code{\link[pagedown]{html_paged}()}.}
}
\value{
R Markdown output format to pass to
\code{\link[rmarkdown:render]{rmarkdown::render()}}
}
\description{
These functions render different versions of the original \code{{posterdown}}
templates with a little IHEID twist to them. All exports are in HTML format.
You can save them by printing them to PDF via a modern browser.

The output format \code{poster_betterland()} mimics the style of the
BetterPoster movement from twitter with an IHEID twist.

The output format \code{poster_betterport()} mimics the style of the
BetterPoster movement from twitter with an IHEID twist.
}
\examples{
\dontrun{
file <- file.path(tempdir(),"foo.rmd")
rmarkdown::draft(file, template="iheiddown_poster", package="iheiddown")
}
}
