% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal.R
\docType{methods}
\name{add_row_signal}
\alias{add_row_signal}
\alias{add_row_signal,Iheatmap-method}
\title{add_row_signal}
\usage{
\S4method{add_row_signal}{Iheatmap}(p, signal, name, title = name,
  xname = NULL, yname = current_yaxis(p), pname = name,
  colorbar_position = get_colorbar_position(p),
  colors = pick_continuous_colors(zmid, zmin, zmax, p = p),
  zmin = min(signal, na.rm = TRUE), zmax = max(signal, na.rm = TRUE),
  zmid = 0, side = c("right", "left"), size = 0.05, buffer = 0.015,
  text = signif(signal, digits = 3), tooltip = setup_tooltip_options(),
  show_colorbar = TRUE, show_title = TRUE, layout = list())
}
\arguments{
\item{p}{iheatmap object}

\item{signal}{vector of signal}

\item{name}{name of colorbar}

\item{title}{label for x axis}

\item{xname}{internal name of xaxis}

\item{yname}{internal name of yaxis}

\item{pname}{internal name of plot}

\item{colorbar_position}{colorbar placement}

\item{colors}{color palette or vector of colors}

\item{zmin}{minimum for colorscale}

\item{zmax}{maximum for colorscale}

\item{zmid}{midpoint for colorscale}

\item{side}{side of plot on which to add dendro}

\item{size}{relative size of dendrogram (relative to the main heatmap)}

\item{buffer}{amount of space to leave empty before this plot, relative to 
size of first heatmap}

\item{text}{text of value to display for data}

\item{tooltip}{tooltip options, see \code{\link{setup_tooltip_options}}}

\item{show_colorbar}{show the colorbar?}

\item{show_title}{show title as axis label}

\item{layout}{list of x axis layout parameters}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
Adds single column heatmap to iheatmap object
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)  
hm <- iheatmap(mat) \%>\% add_row_signal(signal = 1:4, name = "Strength")

# Print heatmap if interactive session 
if (interactive()) hm 
}
\seealso{
\code{\link{iheatmap}}, \code{\link{add_col_groups}}

\code{\link{add_col_signal}}, \code{\link{iheatmap}}, 
\code{\link{add_row_annotation}}
}
\author{
Alicia Schep
}
