% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\docType{methods}
\name{add_row_clusters}
\alias{add_row_clusters}
\alias{add_row_clusters,Iheatmap-method}
\title{add_row_clusters}
\usage{
\S4method{add_row_clusters}{Iheatmap}(p, clusters, name = "Row<br>Clusters",
  reorder = TRUE, side = c("left", "right"), yname = current_yaxis(p),
  ...)
}
\arguments{
\item{p}{iheatmap object}

\item{clusters}{cluster assignments, should be vector of integers, 
characters, or factors}

\item{name}{name of colorbar indicating cluster membership}

\item{reorder}{reorder rows based on clusters? default is TRUE}

\item{side}{side of plot on which to add subplot}

\item{yname}{name of yaxis}

\item{...}{additional arguments to pass to \code{\link{add_row_groups}} for
 creation of annotation
heatmap indicating cluster membership}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
Add row groups and order rows based on groups
}
\details{
This function is very similar to \code{\link{add_row_groups}}; the 
main difference is that with this function rows will get reordered based on 
the groups.
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)
clusters <- c("A","B","A","B")

hm <- iheatmap(mat) \%>\% add_row_clusters(clusters)

# Print heatmap if interactive session 
if (interactive()) hm
}
\seealso{
\code{\link{add_row_clustering}}, \code{\link{add_col_clusters}}, 
\code{\link{iheatmap}}
}
\author{
Alicia Schep
}
