% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_raw_data.r
\name{read_raw_data}
\alias{read_raw_data}
\title{Read raw data from a variety of common sensors.}
\usage{
read_raw_data(
  filename,
  sensor = c("dexcom", "libre", "librepro", "asc", "ipro"),
  id = "filename"
)
}
\arguments{
\item{filename}{String matching the name of the data to be read. Assumed to be .csv}

\item{sensor}{String naming the type of sensor the data was exported from.
Must be one of "dexcom", "libre", "librepro", "asc", or "ipro".}

\item{id}{String indicating subject id. Defaults to "filename".
A value of "read" will cause the program to attempt to read the subject id from the file. A value of "filename" will cause the
program to use the basename of the filename (i.e. filename without any directory information) with .csv removed, as subject id.
A value of "default" will cause the program to use whatever the default value associated with the sensor is.
The asc reader currently does not support id="read"}
}
\value{
A dataframe containing the data read from the named file.
}
\description{
Helper function to assist in reading data directly from sensor outputs. Should return a dataframe in correct format
for use with the rest of the \code{iglu} package. Assumes all data will be readable with base R read.csv function.
}
\details{
A dataframe object with the columns "id", "time" and "gl" and one row per reading will be returned. For the libre reader,
if the phrase "mmol/l" is found in the column names, the glucose values will be multiplied by 18.
Assumes .csv format for all data.
Sensor formats change with ongoing development, so these functions may become depreciated.
If any issues are encountered, contact the package maintainer. This is currently Irina Gaynanova,
who can be reached at \email{irinag@stat.tamu.edu}
Heavily derived from the readers avaiable in the cgmanalysis package's cleandata function.
}
\references{
Vigers et al. (2019) cgmanalysis: An R package for descriptive analysis of continuous glucose monitor data
\emph{PLoS ONE} \strong{14(10)}: e0216851,
\doi{10.1371/journal.pone.0216851}
}
\author{
David Buchanan
}
