% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FgivenP.R
\encoding{UTF-8}
\name{FgivenP}
\alias{FgivenP}
\alias{FP}
\title{Future value given Present value (Engineering Economics)}
\usage{
FgivenP(
  P,
  n,
  i,
  frequency = c("annual", "semiannual", "quarter", "bimonth", "month", "daily")
)

FP(
  P,
  n,
  i,
  frequency = c("annual", "semiannual", "quarter", "bimonth", "month", "daily")
)
}
\arguments{
\item{P}{numeric vector that contains the present value(s)}

\item{n}{numeric vector that contains the period value(s)}

\item{i}{numeric vector that contains the interest rate(s) as a percent}

\item{frequency}{character vector that contains the frequency used to
obtain the number of periods [annual (1), semiannual (2), quarter (4),
bimonth (6), month (12), daily (365)]}
}
\value{
FgivenP numeric vector that contains the future value(s) rounded to
   2 decimal places

FP data.frame of both n (0 to n) and the resulting future values
   rounded to 2 decimal places
}
\description{
Compute F given P
}
\details{
F is expressed as

	\deqn{F = P\left(1 + i\right)^n}

\describe{
\item{\emph{F}}{the "future equivalent"}
\item{\emph{P}}{the "present equivalent"}
\item{\emph{i}}{the "effective interest rate per interest period"}
\item{\emph{n}}{the "number of interest periods"}
}
}
\examples{
library("iemisc")
# Example 4-3 from the Reference text (page 124)
FgivenP(8000, 4, 10, frequency = "annual") # the interest rate is 10\%

FP(8000, 4, 10, frequency = "annual") # the interest rate is 10\%


FgivenP(P = c(1000, 340, 23), n = c(12, 1.3, 3), i = c(10, 2, 0.3),
"annual")
# is is 10\%, 2\%, and 0.3\%
# Can't use FP for this example


# Example 4-29 from the Reference text (page 165-166)
FgivenP(100, 10, 6, "quarter") # the interest rate is 6\% per quarter

FP(100, 10, 6, "quarter") # the interest rate is 6\% per quarter


}
\references{
William G. Sullivan, Elin M. Wicks, and C. Patrick Koelling, \emph{Engineering Economy}, Fourteenth Edition, Upper Saddle River, New Jersey: Pearson/Prentice Hall, 2009, page 124, 142, 164-166.
}
