% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_ieegio_transform.R
\name{io_read_flirt_transform}
\alias{io_read_flirt_transform}
\title{Read FSL FLIRT transformation matrix}
\usage{
io_read_flirt_transform(file, space_from, space_to)
}
\arguments{
\item{file}{character string specifying the path to the FLIRT matrix file.
This is a plain text file containing a 4x4 affine matrix.}

\item{space_from}{character string or \code{ieegio_space} object identifying
the source (moving) space. If missing, will be inferred from the filename
using BIDS-style \code{from-<space>} entity.}

\item{space_to}{character string or \code{ieegio_space} object identifying
the target (reference) space. If missing, will be inferred from the
filename using BIDS-style \code{to-<space>} entity.}
}
\value{
An \code{ieegio_transforms} object with:
\describe{
\item{data}{List containing the 4x4 FLIRT matrix}
\item{type}{\code{"affine"}}
\item{interpretation}{\code{"active"} (FLIRT matrices are point transforms)}
\item{space_from}{Source space (with \code{"FSL"} orientation)}
\item{space_to}{Target space (with \code{"FSL"} orientation)}
\item{dimension}{3}
}
}
\description{
Reads a 4x4 affine transformation matrix from an FSL FLIRT output file.
FLIRT matrices operate in FSL scaled-voxel coordinate system and require
source and reference images to convert to world (RAS) coordinates.
}
\details{
FLIRT matrices operate in FSL scaled-voxel coordinate system, which is:
\itemize{
\item Voxel indices multiplied by voxel sizes (\code{pixdim})
\item X-axis inverted if the image has positive \code{sform} determinant
(neurological convention)
}

The returned transform has \code{"FSL"} orientation for both source and
target spaces. To convert to world (RAS) coordinates, use
\code{\link{transform_flirt2ras}} with the source and/or reference images.

FLIRT matrices are \strong{active} transforms: they map point coordinates
from the source (moving) image space to the reference (fixed) image space.
}
\section{BIDS Support}{

The function can automatically infer space names from BIDS-compliant
file names:
\itemize{
\item \code{from-<source>}: Source space identifier
\item \code{to-<target>}: Target space identifier
}
}

\examples{
\dontrun{
# Read a FLIRT matrix
xfm <- io_read_flirt_transform("source_to_reference.mat")

# Convert to RAS coordinates (requires source and reference images)
xfm_ras <- transform_flirt2ras(xfm, source = "source.nii.gz",
                                reference = "reference.nii.gz")

# Explicitly specify spaces
xfm <- io_read_flirt_transform(
  "transform.mat",
  space_from = "T1w",
  space_to = "MNI152"
)
}

}
\seealso{
\code{\link{transform_flirt2ras}} for converting to world coordinates
\code{\link{io_read_ants_transform}} for reading ANTs format transforms
\code{\link{as_ieegio_transform}} for converting objects to transforms
}
