% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samples.R
\name{ieegio_sample_data}
\alias{ieegio_sample_data}
\title{Download sample files}
\usage{
ieegio_sample_data(file, test = FALSE, cache_ok = TRUE)
}
\arguments{
\item{file}{file to download; set to \code{NULL} to view all possible files}

\item{test}{test whether the sample file exists instead of downloading them;
default is \code{FALSE}}

\item{cache_ok}{whether to use cache}
}
\value{
When \code{test} is false, returns downloaded file path
(character); when \code{test} is true, returns whether the expected
sample exists (logical).
}
\description{
Download sample files
}
\examples{

# list available files
ieegio_sample_data()

# check if file edfPlusD.edf exists
ieegio_sample_data("edfPlusD.edf", test = TRUE)

\dontrun{

ieegio_sample_data("edfPlusD.edf")

}

}
