% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_var_by_strat.R
\name{summarise_var_by_strat}
\alias{summarise_var_by_strat}
\title{Sum a Stratified Variable by Stratification Level}
\usage{
summarise_var_by_strat(df, vars, strat = NULL, new_var, summary_var = FALSE)
}
\arguments{
\item{df}{A dataframe of model output.}

\item{vars}{A character vector containing the unstratified variables to summarise}

\item{strat}{The number of stratifications present in the data set}

\item{new_var}{The name of the summarised variable}

\item{summary_var}{A logical (defaults to \code{FALSE}), specifying whether to add an additional summary variable across
all stratified levels when aggregating incidence.}
}
\value{
An updated data frame containing the summarised variable for each stratified level
and for the whole population.
}
\description{
Sum a Stratified Variable by Stratification Level
}
\details{
Takes compartmental infectious disease output and adds summary statistics for
each stratified population, optionally adding a final summary statistic for the whole population.
}
\examples{
df <- data.frame(A = 1, B = 2)
summarise_var_by_strat(df, vars = c("A", "B"), new_var = "C")

df <- data.frame(A1 = 1, B1 = 1, A2 = 1, B2 = 1, A3 = 1, B3 = 1)
summarise_var_by_strat(df, vars = c("A", "B"), strat = 3, new_var = "C")
summarise_var_by_strat(df, vars = c("A", "B"), strat = 3, new_var = "C", summary_var = TRUE)
}
\seealso{
summarise_var_by_strat
}
