% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_imputation.R
\name{imImpAll}
\alias{imImpAll}
\title{Impute missing data}
\usage{
imImpAll(data.all, fit.rst, normal = TRUE, n.imp = 5, endponly = TRUE,
  deltas = 0, update.progress = NULL, imputeNone = FALSE, ...)
}
\arguments{
\item{data.all}{Original dataset}

\item{fit.rst}{A class \code{IDEM.FIT} results of linear regression.
See \code{\link{imFitModel}}.}

\item{normal}{Logical variable indicating whether normality assumption should
be made for the residuals}

\item{n.imp}{Number of complete datasets required}

\item{endponly}{Logical variable indicating whether clinical outcomes not
used in calculating the final clinical outcome will be imputed. The
default is FALSE, indicating that all missing clinical outcomes will be
imputed sequentially}

\item{deltas}{Vector of imputation sensitivity parameters}

\item{update.progress}{Parameter reserved for run \code{idem} in GUI mode}

\item{imputeNone}{If \code{TRUE}, return subjects that do not need imputation}

\item{...}{options to call STAN sampling. These options include
\code{chains}, \code{iter}, \code{warmup}, \code{thin}, \code{algorithm}.
See \code{rstan::sampling} for details.}
}
\value{
If \code{imputeNone} is TRUE, return a dataset with the original data for the
subset of subjects who died at the end of the study or had no missing outcomes.

Otherwise, return a class \code{IDEM.IMP} list with components
\describe{
\item{lst.var}{List of parameters}
\item{complete}{A dataset with  the original data for
the subset of subjects who died at the end of the study or had no missing
outcomes and the \code{n.imp} imputed missing outcomes for subjects who need
missing value imputation.
}
\item{n.imp}{Number of imputed complete datasets}
\item{deltas}{Imputation sensitivity parameters}
\item{org.data}{Original dataset}
\item{normal}{Normal assumption for the imputation}
\item{stan.par}{parameters in \code{...}}
}
}
\description{
Impute missing data for all the subjects or a small sample of the subjects
}
\examples{

\dontrun{
lst.var <- list(trt="TRT", surv="SURV", outcome=c("Y1","Y2"), y0=NULL,
                endp=c("Y2"), unitTime="days",
                trt.label = c("UC+SBT", "SAT+SBT"),
                cov=c("AGE"), endfml="Y2", duration=365, bounds=c(0,100));
rst.fit <- imFitModel(abc, lst.var);
rst.imp <- imImpAll(abc, rst.fit, deltas=c(-0.25,0,0.25),
                    normal=TRUE, chains = 2, iter = 2000, warmup = 1000);}

}
