% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot_w_points.R
\name{boxplot_w_points}
\alias{boxplot_w_points}
\title{boxplot_w_points}
\usage{
boxplot_w_points(
  ...,
  col_points = "#9033FF3F",
  col_boxplot = "#d2d2d2",
  horizontal = FALSE,
  main = "",
  names = NULL,
  las = 0,
  xlab = "",
  ylab = "",
  seed = 123,
  jitter_param = 0.25
)
}
\arguments{
\item{...}{data vectors to be visualized.}

\item{col_points}{color of the points to be added to the boxplot.}

\item{col_boxplot}{color of the boxplot.}

\item{horizontal}{logical indicating if the boxplots should be horizontal; default FALSE means vertical boxes.}

\item{main}{string indicating the title of the plot.}

\item{names}{vector of string indicating the group labels which will be printed under each boxplot.}

\item{las}{a numeric value indicating the orientation of the tick mark labels and any other text added to a plot after its initialization. The options are as follows: always parallel to the axis (the default, 0), always horizontal (1), always perpendicular to the axis (2), and always vertical (3).}

\item{xlab}{a string indicating the x label.}

\item{ylab}{a string indicating the y label.}

\item{seed}{an integer specifying a seed for the random jitter of the boxplot points.}

\item{jitter_param}{a double specifying the amount of jittering applied on points.}
}
\value{
No return value. Plot a boxplot.
}
\description{
boxplot_w_points
}
\examples{
x <- rnorm(20, mean = 5)
y <- rnorm(20, mean = 10)
z <- rnorm(20, mean = 15)
boxplot_w_points(x, main = "test")
boxplot_w_points(x, y, names = c("x", "y"), las = 1, main = "Data")
boxplot_w_points(x, y, z, names = c("x", "y", "z"), horizontal = TRUE, las = 1, main = "Data")
boxplot_w_points(x, y, z, names = c("x", "y", "z"), horizontal = FALSE, las = 1, main = "Data")
}
