% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{PolToCar}
\alias{PolToCar}
\title{Conversion of spherical coordinates to 3d Cartesian coordinates}
\usage{
PolToCar(longLatMat, radius = authRadius, origin = c(0, 0, 0))
}
\arguments{
\item{longLatMat}{A 2-column numerical matrix with the longitude/latitude data.}

\item{radius}{Single numeric value, indicating the radius of the sphere. Defaults to the R2 radius of Earth (6371.007km).}

\item{origin}{Numeric vector of length 3, the xyz coordinates of the sphere center.}
}
\value{
An xyz 3-column numeric matrix.
}
\description{
The function uses basic trigonometric relationships to transform longitude/latitude coordinates on a sphere to xyz Cartesian coordinates.
}
\details{
The authalic mean radius of Earth (6371.007 km) is used by this function as a default while the origin is c(0,0,0). The precision of these conversions is not exact (see example c(0,90) below),
but should be considered acceptable when applied at a reasonable scale (e.g. for global analyses using data above 10e-6 meters of resolution).
}
\examples{
longLat <- rbind(
    c(0,0),
    #note the precision here!
    c(0, 90),
    c(-45,12)
)

xyz <- PolToCar(longLat)
}

