% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oanda.R
\name{oanda_stream}
\alias{oanda_stream}
\title{OANDA Streaming Data}
\usage{
oanda_stream(instrument, display = 8L, limit, server, apikey)
}
\arguments{
\item{instrument}{string containing the base currency and quote currency
delimited by '_' or '-' (e.g. "USD_JPY" or "usd-jpy"). Use the
\code{\link{oanda_instruments}} function to return a list of all valid
instruments.}

\item{display}{[default 8L] integer rows of data to display in the console
at any one time.}

\item{limit}{(optional) specify a time in seconds by which to limit the
streaming session. The session will end with data returned automatically
after the specified time has elapsed.}

\item{server}{(optional) specify the "practice" or "live" server according to
the account type held. If not specified, will default to "practice", unless
this has been changed by \code{\link{oanda_switch}}.}

\item{apikey}{(optional) string containing the OANDA fxTrade API key (personal
access token), or function that returns this string. Does not need to be
specified if already stored by oanda_set_key(). Can also be entered
interactively if not specified.}
}
\value{
Returned invisibly, a dataframe containing the data for the streaming
    session on function exit. The latest rows of the dataframe are printed to
    the console, as governed by the 'display' argument.
}
\description{
Stream live price and liquidity data for major currencies, metals,
    commodities, government bonds and stock indices from the OANDA fxTrade
    Streaming API.
}
\details{
This function connects to the OANDA fxTrade Streaming API. Use the
    'Esc' key to stop the stream and return the session data.

    Note: only messages of type 'PRICE' are processed. Messages of type
    'HEARTBEAT' consisting of only a timestamp are discarded.
}
\section{Streaming Data}{


    Summarised from the streaming API documentation:

    \itemize{
    \item{Pricing stream does not include every single price created for the
    Account}
    \item{At most 4 prices are sent per second (every 250 milliseconds) for
    each instrument}
    \item{If more than one price is created during the 250 millisecond window,
    only the price in effect at the end of the window is sent}
    \item{This means that during periods of rapid price movement, not every
    price is sent}
    \item{Pricing windows for different connections to the stream are not all
    aligned in the same way (e.g. to the top of the second)}
    \item{This means that during periods of rapid price movement, different
    prices may be observed depending on the alignment for the connection}
    }
}

\section{Further Details}{

    Please refer to the OANDA fxTrade API vignette by calling:
    \code{vignette("xoanda", package = "ichimoku")}.
}

\examples{
\dontrun{
# OANDA fxTrade API key required to run this example
data <- oanda_stream("USD_JPY", display = 8L)
}

}
