% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ichimoku.R
\name{.ichimoku}
\alias{.ichimoku}
\title{ichimoku Technical Utility Version}
\usage{
.ichimoku(x, ticker, periods = c(9L, 26L, 52L), ...)
}
\arguments{
\item{x}{a data.frame object with a POSIXct date-time index as the first
column and numeric OHLC pricing data as the second through fifth columns.}

\item{ticker}{(optional) specify a ticker to identify the instrument,
otherwise this is set to the name of the input object.}

\item{periods}{[default c(9L, 26L, 52L)] a vector defining the length of
periods used for the cloud. This parameter shoud not normally be modified
as using other values would be invalid in the context of traditional
ichimoku analysis.}

\item{...}{additional arguments, for instance 'holidays', passed along to
\code{\link{tradingDays}} for calculating the future cloud on daily data.}
}
\value{
An ichimoku object with S3 classes of 'ichimoku', 'xts' and 'zoo'.
}
\description{
Create an ichimoku object containing values for all components of the
    Ichimoku Kinko Hyo cloud chart. The object encapsulates a date-time
    index, OHLC pricing data, candle direction, the cloud lines Tenkan-sen,
    Kijun-sen, Senkou span A, Senkou span B and Chikou span, as well as
    values for the cloud top and cloud base.
}
\details{
A faster version of \code{\link{ichimoku}} which can be used when
    the data is a dataframe in the prescribed format. Does not support the
    argument 'keep.data'.
}
\keyword{internal}
