% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{extraplot}
\alias{extraplot}
\title{Plot Ichimoku Objects with ggplot2 and gtable}
\usage{
extraplot(
  object,
  window,
  ticker,
  subtitle,
  theme = c("original", "dark", "solarized", "mono"),
  strat = TRUE,
  type = c("none", "r", "s", "bar", "line"),
  custom,
  ...
)
}
\arguments{
\item{object}{an object of class 'ichimoku'.}

\item{window}{(optional) a date-time window to subset the plot, in ISO-8601
compatible range strings of the format used for 'xts' objects, for example
"2020-02-15/2020-08-15" or "2020-02-15/", "/2020-08" or "2020-07".}

\item{ticker}{(optional) specify a ticker (or other text) to include in the
chart heading. If not set, the ticker saved within the ichimoku object
will be used.}

\item{subtitle}{(optional) specify a subtitle to display under the chart title.}

\item{theme}{[default 'original'] with alternative choices of 'dark',
'solarized' or 'mono'.}

\item{strat}{[default TRUE] if the ichimoku object contains a strategy, the
periods for which the strategy results in a position will be shaded, and
the strategy printed as the chart subtitle (if not otherwise specified).
Set to FALSE to turn off this behaviour.}

\item{type}{[default 'none'] type of sub-plot to display beneath the ichimoku
cloud chart, with a choice of 'none', 'r' or 's' for the corresponding
oscillator type, and 'bar' or 'line' for custom plots.}

\item{custom}{(optional) character string (containing a regular expression)
matching the column name of the variable to be displayed as sub-plot.
Specify \code{type = 'bar'} or \code{type = 'line'}, otherwise other type
settings will take precedence.}

\item{...}{other arguments not used by this method.}
}
\value{
A gtable object with S3 classes 'gtable', 'gTree', 'grob' and 'gDesc',
    or else a ggplot2 object with S3 classes 'gg' and 'ggplot' when falling
    back to a standard plot.
}
\description{
Plot Ichimoku Kinko Hyo cloud charts from ichimoku objects with a sub-plot for
    oscillators or a custom specified variable.
}
\details{
The oscillator choices are between 'R-type', which is a modified form
    of a relative strength index (RSI), and 'S-type', which is a modified form
    of a stochastic oscillator. The oscillator look-back parameters are based
    on the fast and medium cloud periods of the ichimoku object.
}
\keyword{internal}
