% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_passive_footprint.R
\name{get_passive_footprint}
\alias{get_passive_footprint}
\title{Download passive fishing gear footprint}
\usage{
get_passive_footprint(
  ecoregion,
  year,
  metier_level4 = NULL,
  datacall = NULL,
  convert2sf = FALSE
)
}
\arguments{
\item{ecoregion}{ICES ecoregion}

\item{year}{which year to select}

\item{metier_level4}{optional gear code (metier level 4) ("FPO")}

\item{datacall}{integer year giving which data call year to inquire about.
If NULL returns the a summary of the most recent approved data.}

\item{convert2sf}{logical, default FALSE, should an simple features object
be returned if the \code{sf} package is installed?}
}
\value{
a data.frame with a WKT column for the c-square polygons
}
\description{
Download a data.frame of presence of fishing by c-square and year
for passive fishing gears (see details).
}
\details{
Passive gears defined as all gears registered under
the metier level 4 codes, FPO (fishing pots), LLS (long lines) and
GNS (set gill nets), with the exclusion of metier level 5 codes
within the GNS category: GNS_SPF and GNS_LPF (set gill nets
targeting small and large pelagic fish).
}
\examples{
\dontrun{
# requires authorization
footprint_map <- get_passive_footprint("Celtic Seas", 2021, convert2sf = TRUE)
plot(footprint_map["ecoregion"], border = FALSE)
}

}
