% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceTAF.R
\name{sourceTAF}
\alias{sourceTAF}
\title{Run TAF Script}
\usage{
sourceTAF(script, local = TRUE, clean = TRUE, quiet = FALSE)
}
\arguments{
\item{script}{script filename.}

\item{local}{whether to run script in a local temporary environment, so that
objects are not created in the global workspace.}

\item{clean}{whether to remove the corresponding TAF directory before running
the script.}

\item{quiet}{whether to suppress messages reporting progress.}
}
\value{
\code{TRUE} or \code{FALSE}, indicating whether the script ran without
errors.
}
\description{
Run a TAF script and return to the original directory.
}
\details{
By default, TAF scripts are run with \code{local = TRUE} to make sure that
only files, not objects, are carried over between scripts. Likewise, the
default \code{clean = TRUE} makes sure that the script starts by creating a
new empty directory.
}
\note{
Commands within a script may change the working directory, but
\code{sourceTAF} guarantees that after running a script, the working
directory reported by \code{getwd()} is the same before and after running a
script.
}
\examples{
\dontrun{
write("print(pi)", "script.R")
source("script.R")
sourceTAF("script.R")
file.remove("script.R")
}

}
\seealso{
\code{\link{source}} is the base function to run R scripts.

\code{\link{makeTAF}} runs a TAF script if needed.

\code{\link{sourceAll}} runs all TAF scripts in a directory.

\code{\link{icesTAF-package}} gives an overview of the package.
}
