% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAGxml.R
\name{stockFishdata}
\alias{stockFishdata}
\title{Create a data.frame of fish stock data}
\usage{
stockFishdata(Year, ...)
}
\arguments{
\item{Year}{a vector of years.}

\item{...}{additional information, e.g. Recruitment, StockSize, Landings, ...}
}
\value{
A data.frame, where all names are valid column names in the SAG database.
}
\description{
This function is a wrapper to \code{data.frame(...)} in which the names are forced to match with
the names required for the SAG database.  See http://dome.ices.dk/datsu/selRep.aspx?Dataset=126
for more details.
}
\examples{
stockFishdata(Year = 1990:2017, Catches = 100)
}
\author{
Colin Millar.
}
